'use strict';

angular.module('genisis').controller('createRequestCtrl', ['$scope', 'source',
  'studyApproval', '$rootScope', '$location', 'request', 'user',
  'api', 'focus', '$window',
  function ($scope, $sources, $studies, $rootScope, $location,
    $requests, $user, $api, $focus, $window) {

    // Check if user can create request or access this page
    if (!$user.allowedToAccess('createRequest')) {
      // redirect back to requests page
      $location.path('/requests');
    }

    //get the request id
    $scope.request = {
      title: null,
      description: null,
      requestTypeId: 1,
      // associatedRequests: [],
      // notify: false,
      sourceId: null,
      // type: null,
      studyApprovalId: null,
      createdBy: $user.username(),
      dataTypeId: null,
      dataType: null
    };

    $scope.sources = $sources;
    $scope.studyApprovals = $studies;
    $scope.studies = [];
    $scope.allRequests = {};
    $scope.associatedRequests = [];
    $scope.selectedRequest = null;
    $scope.selectedStudy = 'Select';

    //load the available study approvals
    $studies.load().then(function (loadedApprovals) {
      $scope.studies = loadedApprovals;
    });

    //load the requests attached to the selected study approval
    $requests.load().then(function (loadedRequests) {
      $scope.allRequests = loadedRequests;
    });

    /**
     * Add an association
     * @param Object request object
     * @return boolean
     **/
    $scope.addAssociation = function (request) {
      if ($scope.associatedRequests.indexOf(request) === -1) {
        $scope.associatedRequests.push(request);
        return true;
      }

      return false;
    };

    $scope.setStudy = function (study) {
      $scope.selectedStudy = study.title;
      $scope.request.studyApprovalId = study.id;
    };

    /**
     * Remove an association
     * @param Object request object
     * @return boolean
     **/
    $scope.removeAssociation = function (request) {
      for (var i = 0; i < $scope.associatedRequests.length; i++) {
        if ($scope.associatedRequests[i].id === request.id) {
          $scope.associatedRequests.splice(i, 1);
          return true;
        }
      }

      return false;
    };

    $scope.getDataSources = function () {
      return $api.retrieve('datasources/', {})
        .then(function (dataSource) {
          if (dataSource.success && dataSource.response) {
            if (dataSource.response instanceof Array) {
              $scope.dataSources = dataSource.response;
            } else {
              $scope.dataSources = [dataSource.response];
            }
          } else {
            $window.alert(dataSource.message);
          }
        });
    };

    $scope.requestTypes = function () {
      return $api.retrieve('requestTypes/', {})
        .then(function (requestType) {
          if (requestType.success && requestType.response) {
            if (requestType.response instanceof Array) {
              $scope.requestTypes = requestType.response;
            } else {
              $scope.requestTypes = [requestType.response];
            }
          } else {
            $window.alert(requestType.message);
          }
        });
    };

    $scope.getDescriptionInfo = function () {
      return $api.retrieve(
          'tooltip/description//VINCI_REQUEST_Description', {})
        .then(function (info) {
          if (info.success && info.response) {
            $window.alert(info.response.textDescription.replace(/ /g,
              '\u00a0').replace(/-/g, '\u2011'));

          } else {
            $window.alert(info.message);
          }
        });
    };

    $scope.focusMain = function () {
      $focus('focus-content');
    };

    $scope.getDataTypes = function () {
      return $api.retrieve('dataTypes/', {})
        .then(function (dataType) {
          if (dataType.success && dataType.response) {
            if (dataType.response instanceof Array) {
              $scope.dataTypes = dataType.response;
            } else {
              $scope.dataTypes = [dataType.response];
            }
          } else {
            $window.alert(dataType.message);
          }
        });
    };
    /**
     * Create a new request
     * @param Object req the request data
     * @return boolean
     **/
    $scope.createRequest = function (req) {
      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(req.title, 'title')) {
        $window.alert('Title exceeds 256 characters');
        return false;
      }

      if ($requests.exceededMaxCharacters(req.description)) {
        // $rootScope.errors.push(
        //   'Description exceeds 3000 characters'
        // );
        $window.alert('Description exceeds 3000 characters');
        return false;
      }

      //add the associated requests
      for (var i = 0; i < $scope.associatedRequests.length; i++) {
        req.associatedRequests.push(
          $scope.associatedRequests[i].id
        );
      }

      //make sure this is a valid request format
      if (!$requests.valid(req)) {
        return false;
      }
      //try to create the new request
      return $api.create('requests', {
        data: req
      }).then(function (request) {
        //redirect them back to the request if it was created successfully
        if (request.success && request.response) {
          $location.path('/requests/' + request.response.id);
          $window.alert('Request created successfully.');
          return true;
        } else if (request && request.message) {
          // $rootScope.errors.push(request.message);
          $window.alert(request.message);
        } else {
          // $rootScope.errors.push('Create request API call failed.');
          $window.alert('Create request API call failed.');
        }

        return false;
      });
    };

    /**
     * Set the request they're trying to link to
     * @param object request
     * @return boolean
     **/
    $scope.setRequest = function (request) {
      $scope.selectedRequest = request;
      return true;
    };
    $scope.getDataSources();
    $scope.getDataTypes();
    $scope.requestTypes();
    $scope.focusMain();
  }
]);